#include "cps.h"

// Input Definitions

static struct BurnInputInfo Cps2FightingInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Weak Punch"    , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Medium Punch"  , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Strong Punch"  , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Weak Kick"     , BIT_DIGITAL  , CpsInp011+0, "p1 fire 4" },
	{"P1 Medium Kick"   , BIT_DIGITAL  , CpsInp011+1, "p1 fire 5" },
	{"P1 Strong Kick"   , BIT_DIGITAL  , CpsInp011+2, "p1 fire 6" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Weak Punch"    , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Medium Punch"  , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Strong Punch"  , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Weak Kick"     , BIT_DIGITAL  , CpsInp011+4, "p2 fire 4" },
	{"P2 Medium Kick"   , BIT_DIGITAL  , CpsInp011+5, "p2 fire 5" },
	{"P2 Strong Kick"   , BIT_DIGITAL  , CpsInp020+6, "p2 fire 6" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Cps2Fighting)

static struct BurnInputInfo NineXXInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Bomb"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Bomb"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(NineXX)

static struct BurnInputInfo Nine44InputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Bomb"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Bomb"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Nine44)

static struct BurnInputInfo ArmwarInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp020+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp020+2, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp011+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp011+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp011+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp011+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp011+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp011+5, "p3 fire 2" },
	{"P3 Shot"          , BIT_DIGITAL  , CpsInp011+6, "p3 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Armwar)

static struct BurnInputInfo AvspInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp020+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp020+2, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp011+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp011+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp011+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp011+0, "p3 right"  },
	{"P3 Shot"          , BIT_DIGITAL  , CpsInp011+4, "p3 fire 1" },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp011+5, "p3 fire 2" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp011+6, "p3 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Avsp)

static struct BurnInputInfo BatcirInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp020+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp020+2, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp011+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp011+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp011+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp011+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp011+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp011+5, "p3 fire 2" },

	{"P4 Coin"          , BIT_DIGITAL  , CpsInp020+7, "p4 coin"   },
	{"P4 Start"         , BIT_DIGITAL  , CpsInp020+3, "p4 start"  },
	{"P4 Up"            , BIT_DIGITAL  , CpsInp010+3, "p4 up"     },
	{"P4 Down"          , BIT_DIGITAL  , CpsInp010+2, "p4 down"   },
	{"P4 Left"          , BIT_DIGITAL  , CpsInp010+1, "p4 left"   },
	{"P4 Right"         , BIT_DIGITAL  , CpsInp010+0, "p4 right"  },
	{"P4 Attack"        , BIT_DIGITAL  , CpsInp010+4, "p4 fire 1" },
	{"P4 Jump"          , BIT_DIGITAL  , CpsInp010+5, "p4 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Batcir)

static struct BurnInputInfo ChokoInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot1"         , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Shot2"         , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Shot3"         , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Choko)

static struct BurnInputInfo CsclubInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Button 1"      , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Button 2"      , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Button 3"      , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Button 1"      , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Button 2"      , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Button 3"      , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Csclub)

static struct BurnInputInfo CybotsInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Low Attack"    , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 High Attack"   , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Boost"         , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Weapon"        , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Low Attack"    , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 High Attack"   , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Boost"         , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Weapon"        , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Cybots)

static struct BurnInputInfo DdsomInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Cycle Item"    , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Use"           , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Cycle Item"    , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Use"           , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp020+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp020+2, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp011+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp011+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp011+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp011+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp011+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp011+5, "p3 fire 2" },
	{"P3 Cycle Item"    , BIT_DIGITAL  , CpsInp011+6, "p3 fire 3" },
	{"P3 Use"           , BIT_DIGITAL  , CpsInp011+7, "p3 fire 4" },

	{"P4 Coin"          , BIT_DIGITAL  , CpsInp020+7, "p4 coin"   },
	{"P4 Start"         , BIT_DIGITAL  , CpsInp020+3, "p4 start"  },
	{"P4 Up"            , BIT_DIGITAL  , CpsInp010+3, "p4 up"     },
	{"P4 Down"          , BIT_DIGITAL  , CpsInp010+2, "p4 down"   },
	{"P4 Left"          , BIT_DIGITAL  , CpsInp010+1, "p4 left"   },
	{"P4 Right"         , BIT_DIGITAL  , CpsInp010+0, "p4 right"  },
	{"P4 Attack"        , BIT_DIGITAL  , CpsInp010+4, "p4 fire 1" },
	{"P4 Jump"          , BIT_DIGITAL  , CpsInp010+5, "p4 fire 2" },
	{"P4 Cycle Item"    , BIT_DIGITAL  , CpsInp010+6, "p4 fire 3" },
	{"P4 Use"           , BIT_DIGITAL  , CpsInp010+7, "p4 fire 4" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Ddsom)

static struct BurnInputInfo DdtodInputList[] =
{
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Use"           , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Cycle Item"    , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Use"           , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Cycle Item"    , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },

	{"P3 Coin"          , BIT_DIGITAL  , CpsInp020+6, "p3 coin"   },
	{"P3 Start"         , BIT_DIGITAL  , CpsInp020+2, "p3 start"  },
	{"P3 Up"            , BIT_DIGITAL  , CpsInp011+3, "p3 up"     },
	{"P3 Down"          , BIT_DIGITAL  , CpsInp011+2, "p3 down"   },
	{"P3 Left"          , BIT_DIGITAL  , CpsInp011+1, "p3 left"   },
	{"P3 Right"         , BIT_DIGITAL  , CpsInp011+0, "p3 right"  },
	{"P3 Attack"        , BIT_DIGITAL  , CpsInp011+4, "p3 fire 1" },
	{"P3 Jump"          , BIT_DIGITAL  , CpsInp011+5, "p3 fire 2" },
	{"P3 Use"           , BIT_DIGITAL  , CpsInp011+6, "p3 fire 3" },
	{"P3 Cycle Item"    , BIT_DIGITAL  , CpsInp011+7, "p3 fire 4" },

	{"P4 Coin"          , BIT_DIGITAL  , CpsInp020+7, "p4 coin"   },
	{"P4 Start"         , BIT_DIGITAL  , CpsInp020+3, "p4 start"  },
	{"P4 Up"            , BIT_DIGITAL  , CpsInp010+3, "p4 up"     },
	{"P4 Down"          , BIT_DIGITAL  , CpsInp010+2, "p4 down"   },
	{"P4 Left"          , BIT_DIGITAL  , CpsInp010+1, "p4 left"   },
	{"P4 Right"         , BIT_DIGITAL  , CpsInp010+0, "p4 right"  },
	{"P4 Attack"        , BIT_DIGITAL  , CpsInp010+4, "p4 fire 1" },
	{"P4 Jump"          , BIT_DIGITAL  , CpsInp010+5, "p4 fire 2" },
	{"P4 Use"           , BIT_DIGITAL  , CpsInp010+6, "p4 fire 3" },
	{"P4 Cycle Item"    , BIT_DIGITAL  , CpsInp010+7, "p4 fire 4" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Ddtod)

static struct BurnInputInfo DimahooInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Bomb"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Shot (auto)"   , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Bomb"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Shot (auto)"   , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Dimahoo)

static struct BurnInputInfo EcofghtrInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Turn 1"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Turn 2"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Turn 1"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Turn 2"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Ecofghtr)

static struct BurnInputInfo GigawingInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Bomb"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Bomb"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Gigawing)

static struct BurnInputInfo JyangokuInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot1"         , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Shot2"         , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Jyangoku)

static struct BurnInputInfo Megaman2InputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Attack"        , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Jump"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Select"        , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Attack"        , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Jump"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Select"        , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Megaman2)

static struct BurnInputInfo Mmancp2uInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Punch"         , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Kick"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Punch"         , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Kick"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Mmancp2u)

static struct BurnInputInfo MmatrixInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Mmatrix)

static struct BurnInputInfo MpangInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot1"         , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Shot2"         , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot1"         , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Shot2"         , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Mpang)

static struct BurnInputInfo ProgearInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Shot"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Bomb"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Auto"          , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Shot"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Bomb"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Auto"          , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Progear)

#define A(a, b, c, d) {a, b, (unsigned char*)(c), d}

static struct BurnInputInfo Pzloop2InputList[] = {
	{"P1 Coin"          , BIT_DIGITAL   , CpsInp020+4   , "p1 coin"     },
	{"P1 Start"         , BIT_DIGITAL   , CpsInp020+0   , "p1 start"    },
	{"P1 Up"            , BIT_DIGITAL   , CpsInp001+3   , "p1 up"       },
	{"P1 Down"          , BIT_DIGITAL   , CpsInp001+2   , "p1 down"     },
	{"P1 Left"          , BIT_DIGITAL   , CpsInp001+1   , "p1 left"     },
	{"P1 Right"         , BIT_DIGITAL   , CpsInp001+0   , "p1 right"    },
	{"P1 Shot"          , BIT_DIGITAL   , CpsInp001+4   , "p1 fire 1"   },
	A("P1 Paddle"       , BIT_ANALOG_REL, &CpsInpPaddle1, "mouse x-axis"),

	{"P2 Coin"          , BIT_DIGITAL   , CpsInp020+5   , "p2 coin"     },
	{"P2 Start"         , BIT_DIGITAL   , CpsInp020+1   , "p2 start"    },
	{"P2 Up"            , BIT_DIGITAL   , CpsInp000+3   , "p2 up"       },
	{"P2 Down"          , BIT_DIGITAL   , CpsInp000+2   , "p2 down"     },
	{"P2 Left"          , BIT_DIGITAL   , CpsInp000+1   , "p2 left"     },
	{"P2 Right"         , BIT_DIGITAL   , CpsInp000+0   , "p2 right"    },
	{"P2 Shot"          , BIT_DIGITAL   , CpsInp000+4   , "p2 fire 1"   },
	A("P2 Paddle"       , BIT_ANALOG_REL, &CpsInpPaddle2, "p2 z-axis" ),

	{"Reset"            , BIT_DIGITAL   , &CpsReset     , "reset"       },
	{"Diagnostic"       , BIT_DIGITAL   , CpsInp021+1   , "diag"        },
	{"Service"          , BIT_DIGITAL   , CpsInp021+2   , "service"     },
};

#undef A

STDINPUTINFO(Pzloop2)

static struct BurnInputInfo QndreamInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Answer 1"      , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Answer 2"      , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Answer 3"      , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Answer 4"      , BIT_DIGITAL  , CpsInp001+7, "p1 fire 4" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Answer 1"      , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Answer 2"      , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Answer 3"      , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Answer 4"      , BIT_DIGITAL  , CpsInp000+7, "p2 fire 4" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset,   "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Qndream)

static struct BurnInputInfo RingdestInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Hold"          , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Weak punch"    , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Strong punch"  , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },
	{"P1 Button 4"      , BIT_DIGITAL  , CpsInp011+0, "p1 fire 4" },
	{"P1 Weak kick"     , BIT_DIGITAL  , CpsInp011+1, "p1 fire 5" },
	{"P1 Strong kick"   , BIT_DIGITAL  , CpsInp011+2, "p1 fire 6" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Hold"          , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Weak punch"    , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Strong punch"  , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },
	{"P2 Button 4"      , BIT_DIGITAL  , CpsInp011+4, "p2 fire 4" },
	{"P2 Weak kick"     , BIT_DIGITAL  , CpsInp011+5, "p2 fire 5" },
	{"P2 Strong kick"   , BIT_DIGITAL  , CpsInp020+6, "p2 fire 6" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Ringdest)

static struct BurnInputInfo SgemfInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Punch"         , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Kick"          , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },
	{"P1 Special"       , BIT_DIGITAL  , CpsInp001+6, "p1 fire 3" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Punch"         , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Kick"          , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },
	{"P2 Special"       , BIT_DIGITAL  , CpsInp000+6, "p2 fire 3" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Sgemf)

static struct BurnInputInfo Spf2tInputList[] = {
	{"P1 Coin"          , BIT_DIGITAL  , CpsInp020+4, "p1 coin"   },
	{"P1 Start"         , BIT_DIGITAL  , CpsInp020+0, "p1 start"  },
	{"P1 Up"            , BIT_DIGITAL  , CpsInp001+3, "p1 up"     },
	{"P1 Down"          , BIT_DIGITAL  , CpsInp001+2, "p1 down"   },
	{"P1 Left"          , BIT_DIGITAL  , CpsInp001+1, "p1 left"   },
	{"P1 Right"         , BIT_DIGITAL  , CpsInp001+0, "p1 right"  },
	{"P1 Rotate 1"   , BIT_DIGITAL  , CpsInp001+4, "p1 fire 1" },
	{"P1 Rotate 2"  , BIT_DIGITAL  , CpsInp001+5, "p1 fire 2" },

	{"P2 Coin"          , BIT_DIGITAL  , CpsInp020+5, "p2 coin"   },
	{"P2 Start"         , BIT_DIGITAL  , CpsInp020+1, "p2 start"  },
	{"P2 Up"            , BIT_DIGITAL  , CpsInp000+3, "p2 up"     },
	{"P2 Down"          , BIT_DIGITAL  , CpsInp000+2, "p2 down"   },
	{"P2 Left"          , BIT_DIGITAL  , CpsInp000+1, "p2 left"   },
	{"P2 Right"         , BIT_DIGITAL  , CpsInp000+0, "p2 right"  },
	{"P2 Rotate 1"   , BIT_DIGITAL  , CpsInp000+4, "p2 fire 1" },
	{"P2 Rotate 2"  , BIT_DIGITAL  , CpsInp000+5, "p2 fire 2" },

	{"Reset"            , BIT_DIGITAL  , &CpsReset  , "reset"     },
	{"Diagnostic"       , BIT_DIGITAL  , CpsInp021+1, "diag"      },
	{"Service"          , BIT_DIGITAL  , CpsInp021+2, "service"   },
};

STDINPUTINFO(Spf2t)
